/**
 * \file: svg_font_harfbuzz.c
 *
 * \version: $Id: svg_font_harfbuzz.c,v 0.1 2014/09/04 11:02:54 $
 *
 * \component:  svg_font_harfbuzz for shaping with harfbuzz library 
 *
 * \author:Karthiraman.R,Anil.V
 *
 * \copyright: (c) 2003 - 2004 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/
#include "grlhb_font.h"



grl_shapeEng_module_fp grl_hb_fp_table = {
						grlhbCreateFont,
						grlhbDeleteFont,
						grlhbGlyphShaping,
						grlhbGetGlyphCount,
						grlhbGetGlyphCharIndex,
						grlhbGetGlyphOffsets,
                                           grlhbSetLangscript_rendrdirection,
						grlhbDestroyBuffer };

SVGError grlhbCreateFont( void *p_shapeeng,FT_Face face )
{
	SVGError	err	= SVG_NO_ERROR;

	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;
	
	if((face != NULL) && (p_hbinfo != NULL))
	{
		p_hbinfo->hb_fonthndl	= hb_ft_font_create(face, 0);

		if( NULL == p_hbinfo->hb_fonthndl )
		{
			err	= HB_FONT_HNDL_CREATION_FAILED;
		}
	}
	else
	{
		err	= SVG_POINTER_NULL;
	}

	return err;
}


SVGError grlhbDeleteFont( void *p_shapeeng )
{
	SVGError	err	= SVG_NO_ERROR;

	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;

	grlhbDestroyBuffer(p_shapeeng);

	if( NULL != p_hbinfo->hb_fonthndl )
	{
		hb_font_destroy(p_hbinfo->hb_fonthndl);
		
		p_hbinfo->hb_fonthndl	= NULL;
	}

	return err;
}

SVGError grlhbGlyphShaping( void *p_shapeeng,
      						get_char_info_struct* pchar_info,
      						void *cachedctx,
      						SVGUint32 encoding)
{
	SVGError			err	= SVG_NO_ERROR;
	hb_buffer_t 		*buffer;	


	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;

	if(p_hbinfo->hb_fonthndl != NULL)
	{
		/**
		  * the call back will be called when glyph metrics is required
		  */
		hb_font_setclbk_cachedglyphmetr(p_hbinfo->hb_fonthndl,
										(void*)cachedctx,
										hb_svg_glyph_metrics);
	
		buffer = hb_buffer_create();

		if(buffer != NULL)
		{
			p_hbinfo->buffer	=	 buffer;
			
			hb_buffer_set_script( buffer, 
								  p_hbinfo->langscript);
									
			hb_buffer_set_direction( buffer, 
									 p_hbinfo->rendr_direction);

			if(encoding != SVG_ENCODING_UTF8)
			{
				if( p_hbinfo->charindexlistsize < (pchar_info->textlength*sizeof(SVGUint32)) )
				{
					GRL_realloc_1D_resource( p_hbinfo->charindexlistsize , 
											 (pchar_info->textlength*sizeof(SVGUint32)),
											 (SVGUint32*)p_hbinfo->p_charIndexList);
											 
					p_hbinfo->charindexlistsize = (pchar_info->textlength*sizeof(SVGUint32));											 
				}

				if(NULL == pchar_info->CharIndexList)
 				{
					err	=	SVG_POINTER_NULL;
				}

				if(err == SVG_NO_ERROR)
				{
					pchar_info->CharIndexList = (SVGUint32*)p_hbinfo->p_charIndexList; 
					
					grlft_get_stringunicodelist(cachedctx,
												pchar_info,
												pchar_info->textlength);

					hb_buffer_add_codepoints( buffer,
											(hb_codepoint_t*)pchar_info->CharIndexList,
											pchar_info->textlength,
											0,
											pchar_info->textlength);
 				} 
			}
			else
			{
				hb_buffer_add_utf8( buffer,
									(char*)pchar_info->theChar,
									pchar_info->textlength,
									0,
									pchar_info->textlength);
			}
			

			if(err == SVG_NO_ERROR)
			{			
				hb_shape(p_hbinfo->hb_fonthndl, buffer, NULL, 0);

			 	p_hbinfo->glyph_count	   = hb_buffer_get_length(buffer);
			    p_hbinfo->glyph_infos      = hb_buffer_get_glyph_infos(buffer, NULL);
				p_hbinfo->glyph_positions  = hb_buffer_get_glyph_positions(buffer, NULL);
			}
		}
		else
		{
			err	=	HB_BUFFER_CREATION_FAILED;
		}
	}
	else
	{
		err	=	SVG_NOT_EXISTENT;		
	}

	return err;
}

SVGUint32 grlhbGetGlyphCount( void *p_shapeeng )
{
	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;

	return((SVGUint32)(p_hbinfo->glyph_count));

}

SVGUint32 grlhbGetGlyphCharIndex( void *p_shapeeng,SVGUint32 glyphindex )
{
	hb_codepoint_t	codepoint	=	0;

	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;
                                           
	if( p_hbinfo->glyph_infos != NULL )
	{
		codepoint	=	p_hbinfo->glyph_infos[glyphindex].codepoint;
	}

	return codepoint;
}

void grlhbGetGlyphOffsets( void *p_shapeeng,
							   SVGUint32 glyphindex,
							   SVGInt32 *Xoffset,
							   SVGInt32 *Yoffset )
{
	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;

	if( p_hbinfo->glyph_positions != NULL)
	{	
		if( Xoffset != NULL )
		{
			*Xoffset	=	(p_hbinfo->glyph_positions[glyphindex].x_offset>>8);
		}

		if( Yoffset != NULL )
		{
			*Yoffset	=	(p_hbinfo->glyph_positions[glyphindex].y_offset>>6);
		}
	}

	return;
}

SVGUint32 grlhbSetLangscript_rendrdirection( void *p_shapeeng,
								SVGUint32 In_langscript,
								SVGUint32 In_Rendrdirection)
{
	hb_script_t	langscript;
	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;
	
	langscript = (hb_script_t)p_hbinfo->langscript;
	p_hbinfo->langscript = (hb_script_t)In_langscript;
	p_hbinfo->rendr_direction = (hb_direction_t)In_Rendrdirection;
	return langscript;
}

void grlhbDestroyBuffer( void *p_shapeeng )
{
	HB_INFO_STRUCT	*p_hbinfo	=	(HB_INFO_STRUCT*)p_shapeeng;

	if( p_hbinfo->buffer != NULL )
	{
		hb_buffer_destroy(p_hbinfo->buffer);

		p_hbinfo->buffer			= NULL;
		p_hbinfo->glyph_positions	= NULL;
		p_hbinfo->glyph_infos		= NULL;
		p_hbinfo->glyph_count   	= 0;
	}
}

grl_shapeEng_module_fp*	grl_GetShapeng_fptable( void )
{
	return (&grl_hb_fp_table);
}

SVGError grl_initShapeEng_Plugin(  void **p_shapeeng,
								   SVGUint32 langscript,
								   SVGUint32 rendr_direction )
{
	SVGError			err	= HB_PLUGIN_INIT_FAILED;

	HB_INFO_STRUCT		*p_hbinfo	=	NULL;

	if( NULL != p_shapeeng )
	{
		p_hbinfo = (HB_INFO_STRUCT*)GRL_malloc_1D_resource(sizeof(HB_INFO_STRUCT));

		if( NULL != p_hbinfo)
		{
			memset(p_hbinfo,0x0,sizeof(HB_INFO_STRUCT));
			
			p_hbinfo->p_charIndexList = GRL_malloc_1D_resource(MAX_SIZE_HB_CHARINDEXLIST); 

			if( NULL != p_hbinfo->p_charIndexList )
			{
				p_hbinfo->charindexlistsize = MAX_SIZE_HB_CHARINDEXLIST;
				
				*p_shapeeng = (void*)p_hbinfo;
				
				/* default settings */
				if(rendr_direction != SVG_RENDER_DIRECTION_INVALID)
				{
					p_hbinfo->rendr_direction		=	(hb_direction_t)rendr_direction;
				}
				else
				{
					p_hbinfo->rendr_direction		=	HB_DIRECTION_LTR;
				}
				
				if(langscript != SVG_SCRIPT_INVALID)
				{
					p_hbinfo->langscript			=	(hb_script_t)langscript;
				}
				else
				{
					p_hbinfo->langscript			=	HB_SCRIPT_LATIN;
				}
				
				err = SVG_NO_ERROR;
			}
			else
			{
				GRL_free_1D_resource(p_hbinfo);
			}
		}
	}

	return err;
}

void grl_ShapeEng_Plugout( void *p_shapeeng )
{
	
	HB_INFO_STRUCT	*p_hbinfo	= (HB_INFO_STRUCT*)p_shapeeng;

 	if(NULL != p_hbinfo )
 	{
		if( NULL != p_hbinfo->p_charIndexList)
		{
			GRL_free_1D_resource(p_hbinfo->p_charIndexList);
		}
		GRL_free_1D_resource(p_shapeeng);
	}
}

hb_bool_t hb_svg_glyph_metrics(hb_font_t *font,
							   hb_codepoint_t glyph,
							   void 	*cachedctx,							   
							   hb_glyph_metrics_t *glyphmetrics)
{
	SVGError	err = SVG_FALSE;

	UNUSED_VAR(font)
	
	SVGFontContext *ctx = (SVGFontContext*)cachedctx;

	err = grlft_get_glyphmetrics( ctx,
								&glyph );

	SVGFontFreeTypeRenderer *p_renderer = (SVGFontFreeTypeRenderer*)
                                           ctx->p_fontRendererContext;
                                           
	if(err == SVG_NO_ERROR)
	{
		glyphmetrics->horz_bearingx		=	p_renderer->shared->cache_current->horz_bearingx;
		glyphmetrics->horz_bearingy		=	p_renderer->shared->cache_current->horz_bearingy;
		glyphmetrics->vert_bearingx		=	p_renderer->shared->cache_current->vert_bearingx;
		glyphmetrics->vert_bearingy		=	p_renderer->shared->cache_current->vert_bearingy;
		glyphmetrics->metrics_width		=	p_renderer->shared->cache_current->metrics_width;
		glyphmetrics->metrics_height	=	p_renderer->shared->cache_current->metrics_height;
		glyphmetrics->metrics_advancex	=	p_renderer->shared->cache_current->metrics_advance_x;	
		glyphmetrics->metrics_advancey	=	p_renderer->shared->cache_current->metrics_advance_y;
		err = SVG_TRUE;		
	}
	return err;
}

